package com.elitescloud.cloudt.system.model.vo.resp.user.sync;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * 账户同步信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/30
 */
@Getter
@Setter
@ApiModel(description = "账户同步信息")
public class UserSyncRecordDetailRespVO implements Serializable {
    private static final long serialVersionUID = 4073230449698103457L;

    @ApiModelProperty(value = "账户ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "登录号", position = 2)
    private String username;

    @ApiModelProperty(value = "姓名", position = 3)
    private String fullName;

    @ApiModelProperty(value = "手机号", position = 4)
    private String mobile;

    @ApiModelProperty(value = "邮箱", position = 5)
    private String email;

    @ApiModelProperty(value = "身份证号", position = 6)
    private String idCard;

    @ApiModelProperty(value = "外部账号", position = 11)
    private String outerUserCode;

    @ApiModelProperty(value = "是否已同步", position = 11)
    private Boolean sync;

    @ApiModelProperty(value = "同步时间", position = 12)
    private LocalDateTime syncTime;

    @ApiModelProperty(value = "同步结果：成功、失败", position = 13)
    private Boolean syncSuccess;

    @ApiModelProperty(value = "同步数据", position = 14)
    private Map<String, Object> syncData;

    @ApiModelProperty(value = "失败原因", position = 15)
    private String failReason;
}
