package com.elitescloud.cloudt.system.model.vo.save.dpr;

import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 数据权限-行规则.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/16
 */
@Data
@ApiModel(description = "数据权限-行规则保存信息")
public class DataPermissionRuleSaveVO implements Serializable {
    private static final long serialVersionUID = 8243240619082255892L;

    @ApiModelProperty(value = "是否是规则组", position = 1)
    private Boolean ruleGroup;

    @ApiModelProperty(value = "组内规则关系", position = 2)
    private DprRuleRelationEnum groupRelation;

    @ApiModelProperty(value = "组内规则列表", position = 3)
    private List<DataPermissionRuleSaveVO> groupRules;

    @ApiModelProperty(value = "规则名称", position = 11, required = true)
    private String dprRuleName;

    @ApiModelProperty(value = "规则字段", position = 12, required = true)
    private String dprRuleField;

    @ApiModelProperty(value = "规则字段类型", position = 13, hidden = true)
    private String ruleFieldType;

    @ApiModelProperty(value = "是否引用资源配置", position = 14)
    private Boolean refResource;

    @ApiModelProperty(value = "引用的业务对象编码", position = 15)
    private String refBusinessObject;
    @ApiModelProperty(value = "引用的业务对象字段", position = 16, hidden = true)
    private String refField;

    @ApiModelProperty(value = "规则条件", position = 17)
    private DprRuleConditionEnum dprRuleCondition;

    @ApiModelProperty(value = "规则值类型", position = 18, required = true)
    @NotNull(message = "规则值类型为空")
    private DprRuleValueTypeEnum dprRuleValueType;

    @ApiModelProperty(value = "数据集类型", position = 19)
    private String dataSet;

    @ApiModelProperty(value = "规则值", position = 20)
    private String dprRuleValue;

    @ApiModelProperty(value = "规则值名称", position = 21)
    private String dprRuleValueName;

    @ApiModelProperty(value = "规则描述", position = 22)
    private String dprRuleDeclare;

    @ApiModelProperty(value = "特用字段1", position = 91)
    private String bs1;

    @ApiModelProperty(value = "特用字段2", position = 92)
    private String bs2;

    @ApiModelProperty(value = "特用字段3", position = 93)
    private String bs3;
}
