package com.elitescloud.cloudt.system.model.vo.save.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;

/**
 * 发送信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
@Data
@ApiModel(description = "发送信息")
public class AlertSendSaveVO implements Serializable {
    private static final long serialVersionUID = 3522082092978269803L;

    /**
     * 业务类型为空
     */
    @NotBlank(message = "业务类型为空")
    @ApiModelProperty(value = "业务类型", position = 1, required = true)
    private String businessType;

    /**
     * 配置分类
     */
    @ApiModelProperty(value = "配置分类", position = 2)
    private String category;

    /**
     * 发送内容
     */
    @ApiModelProperty(value = "发送内容", position = 3)
    private String content;

    /**
     * 发送内容
     */
    @ApiModelProperty(value = "模板参数", position = 5)
    private Map<String, Object> tmplParams;
}
