package com.elitescloud.cloudt.system.model.vo.save.index;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 修改密码.
 *
 * @author Kaiser（wang shao）
 * 2022/12/13
 */
@ApiModel(description = "修改密码")
@Data
public class PasswordUpdateSaveVO implements Serializable {
    private static final long serialVersionUID = -5758639837761992676L;

    @ApiModelProperty(value = "账号", position = 1, required = true)
    @NotBlank(message = "账号不能为空")
    private String account;

    @ApiModelProperty(value = "账号类型（mobile-手机号，email-邮箱），默认手机号", position = 2)
    private String accountType;

    @ApiModelProperty(value = "验证码", position = 3, required = true)
    @NotBlank(message = "验证码不能为空")
    private String verifyCode;

    @ApiModelProperty(value = "新的密码", position = 4, required = true)
    @NotBlank(message = "新的密码不能为空")
    private String password;
}
