package com.elitescloud.cloudt.system.model.vo.save.org;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * 员工的组织信息.
 *
 * @author Kaiser（wang shao）
 * @date 2/3/2023
 */
@Data
@ApiModel(description = "员工的组织信息")
public class EmployeeOrgSaveVO implements Serializable {
    private static final long serialVersionUID = 7953069186460100692L;

    @ApiModelProperty(value = "组织ID", position = 1)
    private Long orgId;

    @ApiModelProperty(value = "上级领导ID", position = 2)
    private Long leaderUserId;

    @ApiModelProperty(value = "员工所在组织的岗位ID", position = 3)
    private Long positionId;

    @ApiModelProperty(value = "是否默认组织", position = 4)
    private Boolean def;

    @ApiModelProperty(value = "是否负责人", position = 5)
    private Boolean assignee;
}
