package com.elitescloud.cloudt.system.model.vo.save.role;

import com.elitescloud.cloudt.system.common.DprPropagateStrategyEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 权限的向下传递.
 *
 * @author Kaiser（wang shao）
 * @date 2025/1/16
 */
@Getter
@Setter
public class RolePermissionPropagationSaveVO implements Serializable {
    private static final long serialVersionUID = 7556777303562422759L;

    @NotNull(message = "角色ID为空")
    @ApiModelProperty(value = "角色ID", required = true)
    private Long roleId;

    @NotNull(message = "业务对象编码为空")
    @ApiModelProperty(value = "业务对象编码", required = true)
    private String businessObjectCode;

    @NotNull(message = "传递策略为空")
    @ApiModelProperty(value = "向下传递策略", required = true)
    private DprPropagateStrategyEnum strategy;
}
