package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysUserType;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Slf4j
@Component
public class DprSysInternallyDynamic implements DprValueResolverSPI {
    public static final String PREFIX = SysDprValueType.DPR_SYS_INTERNALLY_DYNAMIC.code() + "::userType::";

    @Override
    public @NotEmpty DprValueType[] valueTypes() {
        return new DprValueType[]{SysDprValueType.DPR_SYS_INTERNALLY_DYNAMIC};
    }

    @Override
    public DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails userInfo, @NotNull SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        var userType = ruleDTO.getDprRuleValue().substring(PREFIX.length());

        Long value = null;
        for (SysUserType sysUserType : userInfo.getUser().getUserTypeList()) {
            if (userType.equals(sysUserType.getUserType()) && StringUtils.hasText(sysUserType.getIdentityId())) {
                value = Long.parseLong(sysUserType.getIdentityId());
            }
        }

        DprRuleValue dprRuleValue = new DprRuleValue();
        if (value != null) {
            dprRuleValue.setValue(value);
        } else {
            log.error("数据权限错误：账号没有{}信息", userType);
        }

        return dprRuleValue;
    }
}
