package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import com.elitescloud.cloudt.system.modules.dpr.strategy.DprSysInternallyStrategyUtil;
import com.elitescloud.cloudt.system.service.OrgQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:24
 */
@Service
@Slf4j
public class DprSysInternallyOrgSub implements DprValueResolverSPI {

    @Autowired
    private  OrgQueryService orgQueryService;

    @Override
    public @NotEmpty DprValueType[] valueTypes() {
        return new DprValueType[] {SysDprValueType.DPR_SYS_INTERNALLY_ORG_SUB};
    }

    @Override
    public DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails userInfo, @NotNull SysDprRoleApiDataRuleListQueryDTO sysDprRoleApiDataRuleListQueryDTO) {
        DprRuleValue dprRuleValueSysInternallyBo = new DprRuleValue();

        // 下级组织
        var subOrgIds = DprSysInternallyStrategyUtil.querySubOrgId(orgQueryService, userInfo.getOrgId());
        dprRuleValueSysInternallyBo.setValue(subOrgIds);

        return dprRuleValueSysInternallyBo;
    }
}
