package com.elitescloud.cloudt.system.modules.finereport.config;

import com.elitescloud.boot.swagger.common.BaseSwaggerConfig;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.spring.web.plugins.Docket;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/21
 */
@Configuration
@ConditionalOnProperty(prefix = "knife4j", name = "enable", havingValue = "true")
public class FineReportSwagger extends BaseSwaggerConfig {

    public FineReportSwagger(OpenApiExtensionResolver openApiExtensionResolver, ServerProperties serverProperties) {
        super(openApiExtensionResolver, serverProperties);
    }

    @Bean
    public Docket createFindReportRestApi() {
        return createDocket("FineReportAPI", "com.elitescloud.cloudt.system.modules.finereport.controller");
    }
}
