package com.elitescloud.cloudt.system.modules.finereport.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.modules.finereport.model.ViewReportParamRespVO;
import com.elitescloud.cloudt.system.modules.finereport.service.FineReportService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/21
 */
@Api(tags = "帆软报表")
@RestController
@RequestMapping(value = "/common/fineReport", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class FineReportController {

    private FineReportService fineReportService;

    @ApiOperation(value = "获取ssoToken")
    @ApiOperationSupport(order = 1)
    @GetMapping(value = "/ssoToken")
    public ApiResult<String> getSsoToken() {
        return fineReportService.getSsoToken();
    }

    @ApiOperation(value = "查看报表")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "viewlet", value = "模板路径", required = false),
            @ApiImplicitParam(name = "encoded", value = "是否token加密", required = false, defaultValue = "true", dataType = "boolean"),
    })
    @GetMapping(value = "/view/report")
    public ApiResult<ViewReportParamRespVO> viewReport(@RequestParam(name = "viewlet", required = false) String viewlet,
                                                       @RequestParam(name = "encoded", required = false, defaultValue = "true") Boolean encoded) {
        return fineReportService.viewReport(viewlet, encoded);
    }

    @Autowired
    public void setFineReportService(FineReportService fineReportService) {
        this.fineReportService = fineReportService;
    }
}
