package com.elitescloud.cloudt.system.modules.message.repository;

import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateConfigDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 13:55
 */

@Repository
public interface SysMsgTemplateConfigRepository extends JpaRepository<SysMsgTemplateConfigDO, Long>, QuerydslPredicateExecutor<SysMsgTemplateConfigDO> {


    /**批量删除模板的配置**/
    Long deleteByTemplateId(Long templateId);


    /**查询模板id，条件发送类型开关**/
    List<SysMsgTemplateConfigDO> findAllByTemplateIdAndSendTypeSwitch(Long templateId,Boolean sendTypeSwitch);
}