package com.elitescloud.cloudt.system.modules.message.service;

import cn.zhxu.bs.SearchResult;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.modules.message.sbean.SysMsgSendRecordDtlQueryBean;
import com.elitescloud.cloudt.system.modules.message.sbean.SysMsgSendRecordQueryBean;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgSendRecordDeleteVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgSendRecordDtlInteriorQueryVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgSendRecordQueryVO;
import com.elitescloud.cloudt.system.param.SysMsgSentResultDTO;
import com.elitescloud.cloudt.system.param.SysMsgViewResultDTO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Set;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 13:58
 */
public interface SysMsgSendRecordService {

    /***
     * 明细表 更新已读字段， 系统站内使用
     * @param id 更新id
     * @return
     */
    ApiResult<Boolean> interiorReadUpdate(Long id, Boolean readFlg);

    /**
     * 批量修改已读状态
     *
     * @param ids    记录标识
     * @param viewed 是否已读
     * @return 记录ID
     */
    ApiResult<Boolean> updateViewed(@NotEmpty Set<Long> ids, Boolean viewed);

    /***
     * 查询明细，用于系统站内数据查询 bean searcher查询 分页
     * @param qvo 查询参数
     * @return
     */
    ApiResult<SearchResult<SysMsgSendRecordDtlQueryBean>> sysMsgSendRecordDtlInteriorQuery(SysMsgSendRecordDtlInteriorQueryVO qvo);

    ApiResult<SysMsgSendRecordDtlQueryBean> sysMsgSendRecordDtlInteriorByDtlIdQuery(Long dtlId, Long userId);

    /**
     * 统计待读的站内信数量
     *
     * @return 数量
     */
    ApiResult<Long> countToView();

    /**
     * 查询详细信息
     *
     * @param msgId 消息ID
     * @return 消息信息
     */
    ApiResult<SysMsgSendRecordDtlQueryBean> getRecordDetail(@NotBlank String msgId);

    /***
     * 根据主表ID查询全部发送记录明细
     * @param sendRecordId
     * @return
     */
    ApiResult<List<SysMsgSendRecordDtlQueryBean>> sysMsgSendRecordDtlByRecordId(Long sendRecordId);

    /***
     * 根据条件检索查询主表数据 分页
     * @param queryVO 查询参数
     * @return
     */
    ApiResult<SearchResult<SysMsgSendRecordQueryBean>> sysMsgSendRecordQuery(SysMsgSendRecordQueryVO queryVO);

    /***
     * 批量删除主表，级联删除明细
     * @param sendRecordIds 主表id
     * @return
     */
    ApiResult<Boolean> sysMsgSendRecordDelete(SysMsgSendRecordDeleteVO sysMsgSendRecordDeleteVO);

    /**
     * 查询发送结果
     *
     * @param batchUuids 发送记录标识
     * @return 结果
     */
    ApiResult<List<SysMsgSentResultDTO>> querySentResult(Set<String> batchUuids);

    /**
     * 获取消息的阅读结果
     *
     * @param batchUuid 发送记录标识
     * @return 阅读结果
     */
    ApiResult<List<SysMsgViewResultDTO>> getViewedResult(@NotBlank String batchUuid);

    /**
     * 查询发送结果
     *
     * @param batchUuid
     * @return
     */
    ApiResult<com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO> querySentResult(@NotBlank String batchUuid);

    /**
     * 查询发送结果
     *
     * @param batchUuidList
     * @return
     */
    ApiResult<List<com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO>> querySentResults(@NotEmpty Set<String> batchUuidList);

    /**
     * 重试发送
     *
     * @param batchUuid 批记录ID
     * @return 记录ID
     */
    ApiResult<String> retrySend(@NotBlank String batchUuid);
}
