package com.elitescloud.cloudt.system.modules.orgtree.common;

import lombok.Getter;

/**
 * 该枚举类并不维护所有的 UDC
 * 实际有哪些 UDC，以及 UDC 实际值有哪些请以数据库为准
 * 只有当后端业务代码中需要使用 UDC 的时候，才会将 UDC 的值维护到该枚举类当中，然后进行使用
 * 如果发现这里维护的 UDC 数据库中没有，请联系产品或设计。
 * 如果发现这里维护的 UDC 的值与数据库不一致，请以数据库为准，并将这里维护的值修改为和数据库相同
 *
 * 一切以数据库为准
 * 一切以数据库为准
 * 一切以数据库为准
 *
 * @author Chris
 * @date 2021-03-22
 */
public enum OrgUdcEnum {

    /**
     * 组织类型
     */
    BU_TYPE_OU("ORG", UdcCodeNameEnum.BU_TYPE.getCode(), UdcCodeNameEnum.BU_TYPE.getName(), "OU", "公司", 10, 1),
    BU_TYPE_WH("ORG", UdcCodeNameEnum.BU_TYPE.getCode(), UdcCodeNameEnum.BU_TYPE.getName(), "WH", "仓库", 20, 1),
    BU_TYPE_GRID("ORG", UdcCodeNameEnum.BU_TYPE.getCode(), UdcCodeNameEnum.BU_TYPE.getName(), "GRID", "网格", 30, 1),
    BU_TYPE_STORE("ORG", UdcCodeNameEnum.BU_TYPE.getCode(), UdcCodeNameEnum.BU_TYPE.getName(), "STORE", "营业厅", 40, 1),
    BU_TYPE_DEPT("ORG", UdcCodeNameEnum.BU_TYPE.getCode(), UdcCodeNameEnum.BU_TYPE.getName(), "DEPT", "部门", 40, 1),
    BU_TYPE_SALE_BU("ORG", UdcCodeNameEnum.BU_TYPE.getCode(), UdcCodeNameEnum.BU_TYPE.getName(), "SALE_BU", "销售组织", 50, 1),
    BU_TYPE_PURC_BU("ORG", UdcCodeNameEnum.BU_TYPE.getCode(), UdcCodeNameEnum.BU_TYPE.getName(), "PURC_BU", "采购组织", 60, 1),
    BU_TYPE_REGION("ORG", UdcCodeNameEnum.BU_TYPE.getCode(), UdcCodeNameEnum.BU_TYPE.getName(), "REGION", "区域", 70, 0),
    BU_TYPE_JGJT("ORG", UdcCodeNameEnum.BU_TYPE.getCode(), UdcCodeNameEnum.BU_TYPE.getName(), "JGJT", "经管", 80, 0),
    BU_TYPE_SHOP("ORG", UdcCodeNameEnum.BU_TYPE.getCode(), UdcCodeNameEnum.BU_TYPE.getName(), "SHOP", "线上店铺", 90, 0),
    BU_TYPE_AFTSALE("ORG", UdcCodeNameEnum.BU_TYPE.getCode(), UdcCodeNameEnum.BU_TYPE.getName(), "AFTSALE", "售后", 100, 0),
    /**
     * 店铺类型
     */
    BU_TYPE2_A("ORG", "BU_TYPE2", UdcCodeNameEnum.BU_TYPE.getName(), "A", "自营店铺", 10, 0),
    BU_TYPE_B("ORG", "BU_TYPE2", UdcCodeNameEnum.BU_TYPE.getName(), "B", "分子公司第三方", 20, 0),
    BU_TYPE_C("ORG", "BU_TYPE2", UdcCodeNameEnum.BU_TYPE.getName(), "C", "项目公司第三方", 30, 0),
    BU_TYPE_D("ORG", "BU_TYPE2", UdcCodeNameEnum.BU_TYPE.getName(), "D", "外部第三方", 40, 0),

    /**
     * 组织状态
     */
    BU_STATUS_DRAFT("ORG", UdcCodeNameEnum.BU_STATUS.getCode(), UdcCodeNameEnum.BU_STATUS.getName(), "DRAFT", "草稿", 0, 1),
    BU_STATUS_ACTIVE("ORG", UdcCodeNameEnum.BU_STATUS.getCode(), UdcCodeNameEnum.BU_STATUS.getName(), "ACTIVE", "正常", 0, 1),
    BU_STATUS_CLOSED("ORG", UdcCodeNameEnum.BU_STATUS.getCode(), UdcCodeNameEnum.BU_STATUS.getName(), "CLOSED", "已停用", 0, 1),

    /**
     * 公司状态
     */
    OU_STATUS("yst-supp", UdcCodeNameEnum.OU_STATUS.getCode(), UdcCodeNameEnum.OU_STATUS.getName(), "", "", 0, 1),
    OU_STATUS_DRAFT("ORG", UdcCodeNameEnum.OU_STATUS.getCode(), UdcCodeNameEnum.OU_STATUS.getName(), "DRAFT", "草稿", 0, 1),
    OU_STATUS_ACTIVE("ORG", UdcCodeNameEnum.OU_STATUS.getCode(), UdcCodeNameEnum.OU_STATUS.getName(), "ACTIVE", "正常", 0, 1),
    OU_STATUS_CLOSED("ORG", UdcCodeNameEnum.OU_STATUS.getCode(), UdcCodeNameEnum.OU_STATUS.getName(), "CLOSED", "已停用", 0, 1),

    /**
     * 地址薄类型
     */
    ADDR_TYPE_BU("ORG", UdcCodeNameEnum.ADDR_TYPE.getCode(), UdcCodeNameEnum.ADDR_TYPE.getName(), "BU", "组织", 0, 1),
    ADDR_TYPE_CUST("ORG", UdcCodeNameEnum.ADDR_TYPE.getCode(), UdcCodeNameEnum.ADDR_TYPE.getName(), "CUST", "客户", 0, 1),
    ADDR_TYPE_SUPP("ORG", UdcCodeNameEnum.ADDR_TYPE.getCode(), UdcCodeNameEnum.ADDR_TYPE.getName(), "SUPP", "供应商", 0, 1),
    ADDR_TYPE_EMP("ORG", UdcCodeNameEnum.ADDR_TYPE.getCode(), UdcCodeNameEnum.ADDR_TYPE.getName(), "EMP", "员工", 0, 1),
    ADDR_TYPE_SCUST("ORG", UdcCodeNameEnum.ADDR_TYPE.getCode(), UdcCodeNameEnum.ADDR_TYPE.getName(), "SCUST", "潜在客户", 0, 1),

    /**
     * 地址薄-地址类型
     */
    ADDRESS_TYPE_DEFAULT("ORG", UdcCodeNameEnum.ADDRESS_TYPE.getCode(), UdcCodeNameEnum.ADDRESS_TYPE.getName(), "DEFAULT", "默认地址", 0, 0),
    ADDRESS_TYPE_RECEIVE("ORG", UdcCodeNameEnum.ADDRESS_TYPE.getCode(), UdcCodeNameEnum.ADDRESS_TYPE.getName(), "RECEIVE", "收货地址", 0, 0),
    ADDRESS_TYPE_INVOICE("ORG", UdcCodeNameEnum.ADDRESS_TYPE.getCode(), UdcCodeNameEnum.ADDRESS_TYPE.getName(), "INVOICE", "开票地址", 0, 0),
    ADDRESS_TYPE_OTHER("ORG", UdcCodeNameEnum.ADDRESS_TYPE.getCode(), UdcCodeNameEnum.ADDRESS_TYPE.getName(), "OTHER", "其它", 0, 0),

    /**
     * 地址薄-银行账户类型
     */
    ADDR_BANKACC_TYPE_IN("ORG", "ADDR_BANKACC_TYPE", "收款账号", "IN", "收款账号", 0, 0),

    /**
     * 员工状态
     */
    EMP_STATUS_ENABLE("ORG", "EMP_STATUS", "员工状态", "ACTIVE", "启用", 0, 1),
    EMP_STATUS_DISABLE("ORG", "EMP_STATUS", "员工状态", "CLOSED", "禁用", 0, 1),

    /**
     * 员工任职状态
     */
    EMP_POS_STATUS_ENABLE("ORG", "EMP_POS_STATUS", "员工任职状态", "ACTIVE", "有效", 0, 1),
    EMP_POS_STATUS_DISABLE("ORG", "EMP_POS_STATUS", "员工任职状态", "INVALID", "无效", 0, 1),

    /**
     * 员工性别
     */
    EMP_GENDER_MALE("ORG", "EMP_GENDER", "员工性别", "MALE", "男", 0, 0),
    EMP_GENDER_FEMALE("ORG", "EMP_GENDER", "员工性别", "FEMALE", "女", 0, 0),

    /**
     * 员工类型
     */
    EMP_TYPE_A("ORG", UdcCodeNameEnum.EMP_TYPE.getCode(), UdcCodeNameEnum.EMP_TYPE.getName(), "A", "雇员", 0, 1),
    EMP_TYPE_B("ORG", UdcCodeNameEnum.EMP_TYPE.getCode(), UdcCodeNameEnum.EMP_TYPE.getName(), "B", "销售员", 0, 1),
    EMP_TYPE_C("ORG", UdcCodeNameEnum.EMP_TYPE.getCode(), UdcCodeNameEnum.EMP_TYPE.getName(), "C", "网格员", 0, 1),
    EMP_TYPE_D("ORG", UdcCodeNameEnum.EMP_TYPE.getCode(), UdcCodeNameEnum.EMP_TYPE.getName(), "D", "采购员", 0, 1),
    EMP_TYPE_E("ORG", UdcCodeNameEnum.EMP_TYPE.getCode(), UdcCodeNameEnum.EMP_TYPE.getName(), "E", "网格长", 0, 1),
    EMP_TYPE_F("ORG", UdcCodeNameEnum.EMP_TYPE.getCode(), UdcCodeNameEnum.EMP_TYPE.getName(), "F", "增值网格员", 0, 1),
    EMP_TYPE_G("ORG", UdcCodeNameEnum.EMP_TYPE.getCode(), UdcCodeNameEnum.EMP_TYPE.getName(), "G", "营业厅店长", 0, 1),
    EMP_TYPE_H("ORG", UdcCodeNameEnum.EMP_TYPE.getCode(), UdcCodeNameEnum.EMP_TYPE.getName(), "H", "导购", 0, 1),
    EMP_TYPE_J("ORG", UdcCodeNameEnum.EMP_TYPE.getCode(), UdcCodeNameEnum.EMP_TYPE.getName(), "J", "客服", 0, 1),

    /**
     * 门店状态
     */
    STORE_STATUS_ENABLE("ORG", "STORE_STATUS", "门店状态", "ACTIVE", "启用", 0, 1),
    STORE_STATUS_DISABLE("ORG", "STORE_STATUS", "门店状态", "CLOSED", "禁用", 0, 1),


    /**
     * 纳税了类型
     */
    TAXPAYER_TYPE_V("ORG", UdcCodeNameEnum.TAXPAYER_TYPE.getCode(), UdcCodeNameEnum.TAXPAYER_TYPE.getName(), "V", "增值税纳税人", 0, 1),
    TAXPAYER_TYPE_S("ORG", UdcCodeNameEnum.TAXPAYER_TYPE.getCode(), UdcCodeNameEnum.TAXPAYER_TYPE.getName(), "S", "小规模纳税人", 0, 1),
    TAXPAYER_TYPE_E("ORG", UdcCodeNameEnum.TAXPAYER_TYPE.getCode(), UdcCodeNameEnum.TAXPAYER_TYPE.getName(), "E", "不纳税", 0, 1),

    /**
     * 地址簿资质类型
     */
    ADDR_QUALIFY_TYPE_10("ORG", "ADDR_QUALIFY_TYPE", "地址簿资质类型", "10", "法人营业执照", 0, 1),
    ADDR_QUALIFY_TYPE_OTHER("ORG", "ADDR_QUALIFY_TYPE", "地址簿资质类型", "OTHER", "其它", 0, 1),

    ORG_OU_TYPE_10("ORG", "OU_TYPE", "公司类型", "10", "集团公司", 0, 1),



    // 组织树状态
    ORG_BUTREE_STATUS_DRAFT("ORG",UdcCodeNameEnum.ORG_BUTREE.getCode(),UdcCodeNameEnum.ORG_BUTREE.getName(),"DRAFT","草稿",0,1),
    ORG_BUTREE_STATUS_ACTIVE("ORG",UdcCodeNameEnum.ORG_BUTREE.getCode(),UdcCodeNameEnum.ORG_BUTREE.getName(),"ACTIVE","正常",0,1),
    ORG_BUTREE_STATUS_CLOSED("ORG",UdcCodeNameEnum.ORG_BUTREE.getCode(),UdcCodeNameEnum.ORG_BUTREE.getName(),"CLOSED","已停用",0,1),

    // 公司归类
    OU_TYPE2("yst-supp",UdcCodeNameEnum.OU_TYPE2.getCode(),UdcCodeNameEnum.OU_TYPE2.getName(),"","",0,1),
    OU_TYPE2_INNER("ORG",UdcCodeNameEnum.OU_TYPE2.getCode(),UdcCodeNameEnum.OU_TYPE2.getName(),"INNER","集团内公司",0,1),
    OU_TYPE2_OUTER("ORG",UdcCodeNameEnum.OU_TYPE2.getCode(),UdcCodeNameEnum.OU_TYPE2.getName(),"OUTER","外部公司",0,1),

    //公司类型
    OU_TYPE("yst-supp",UdcCodeNameEnum.OU_TYPE.getCode(),UdcCodeNameEnum.OU_TYPE.getName(),"","",0,1)
    ;

    /**
     * 领域编码
     */
    @Getter
    private final String domainCode;
    /**
     * udc编码
     */
    @Getter
    private final String udcCode;
    /**
     * udc名称
     */
    @Getter
    private final String udcName;
    /**
     * udc值
     */
    @Getter
    private final String udcVal;
    /**
     * 值描述
     */
    @Getter
    private final String valDesc;
    /**
     * 排序号
     */
    @Getter
    private final int valSortNo;
    /**
     * 硬编码，即是否内置，
     * 1:中台内置UDC(不允许修改)，也就是产品级数据，所有项目通用
     * 0:非中台内置UDC，也就是项目级数据，不同的项目自定义
     */
    @Getter
    private final int hdFlag;

    OrgUdcEnum(String domainCode, String udcCode, String udcName, String udcVal, String valDesc, int valSortNo, int hdFlag) {
        this.domainCode = domainCode;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.udcVal = udcVal;
        this.valDesc = valDesc;
        this.valSortNo = valSortNo;
        this.hdFlag = hdFlag;
    }
}
