package com.elitescloud.cloudt.system.modules.orgtree.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeAndTreeDDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeSaveParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVSaveParam;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/15
 */
@Mapper(config = BaseMapperConfig.class)
public interface OrgBuTreeConvert {

    OrgBuTreeConvert INSTANCE = Mappers.getMapper(OrgBuTreeConvert.class);

    /**
     * saveParam转DO
     *
     * @param param
     * @return
     */
    OrgBuTreeDO saveParamToDo(OrgBuTreeSaveParam param);

    /**
     * saveVD to do
     *
     * @param param
     * @return
     */
    OrgBuTreeDO saveVDParaToDo(OrgBuTreeVSaveParam param);

    /**
     * vo to vo
     *
     * @param vo
     * @return
     */
    OrgBuTreeAndTreeDDTO dtoToDDto(OrgBuTreeDTO vo);


    /**
     * 更新 save param to do
     *
     * @param param       保存参数
     * @param orgBuTreeDO do
     */
    @Mapping(target = "id", ignore = true)
    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void updateDoFromSaveParam(OrgBuTreeSaveParam param, @MappingTarget OrgBuTreeDO orgBuTreeDO);


    @Mapping(target = "id", ignore = true)
    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void updateDoFromParamV(@MappingTarget OrgBuTreeDO orgBuTreeDO, OrgBuTreeVSaveParam param);
}
