package com.elitescloud.cloudt.system.modules.orgtree.service;

import com.elitescloud.cloudt.system.modules.orgtree.model.*;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeDParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeDSaveParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVListParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVSaveParam;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
public interface OrgBuTreeDDomainService {

    /**
     * 组织树明细新增
     *
     * @param paramList
     * @return
     */
    List<OrgBuTreeDDetailDTO> orgBuTreeDCreate(List<OrgBuTreeDSaveParam> paramList);

    /**
     * 通过id查询所有下级
     * 通过id查询下一级
     *
     * @param id
     * @param searchType
     * @param buTreeId
     * @return
     */
    List<OrgBuTreedAllDTO> orgBuTreedAllSearch(Long id, String searchType, Long buTreeId);

    /**
     * 获取组织树形结构
     *
     * @param buTreeId
     * @param searchType
     * @return
     */
    List<OrgBuTreeDDTO> orgBuTreeDSearchTree(Long buTreeId, String searchType, Long buTreeDId);

    /**
     * 组织树节点删除
     *
     * @param id
     */
    void deleteTreeDetail(Long id, Long buTreedId);

    /**
     * 新增组织树版本数据
     *
     * @param param 数据参数
     */
    void saveBuTreeDV(OrgBuTreeVSaveParam param);

    /**
     * 根据组织号获取组织信息
     *
     * @param buTreeCode 组织树编码
     * @return list
     */
    List<String> getBuTreeVersionByBuTreeCode(String buTreeCode);

    /**
     * 根据组织号获取所有组织树信息
     *
     * @param param 组织树编码
     * @return list
     */
    List<OrgBuTreeDTO> getBuTreeListByParam(OrgBuTreeVListParam param);

    /**
     * 根据param获取 组织树节点版本信息
     *
     * @param param param
     * @return list
     */
    OrgBuTreeAndTreeDDTO getBuTreeDListByBuTreeCode(OrgBuTreeVListParam param);

    /**
     * 发布组织树版本
     *
     * @param id 组织树id
     */
    void releaseBuTreeVersion(Long id);


    /**
     * 根据param 获取组织树节点  仅获取节点数据 并无上下级信息
     *
     * @param param param
     * @return 组织树节点信息
     */
    List<OrgBuTreeDDTO> findBuTreeDByParam(OrgBuTreeDParam param);

}
