package com.elitescloud.cloudt.system.modules.orgtree.service.repo;

import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
@Repository
public interface OrgBuTreeDRepo extends JpaRepository<OrgBuTreeDDO, Long>, QuerydslPredicateExecutor<OrgBuTreeDDO> {

    /**
     * 通过buTreeId、buId查询组织树节点明细
     * @param buTreeId
     * @param buId
     * @return
     */
    Optional<OrgBuTreeDDO> findByBuTreeIdAndBuId(Long buTreeId, Long buId);

    /**
     * 通过buTreeId查询组织树节点明细
     * @param buTreeId
     * @return
     */
    Optional<List<OrgBuTreeDDO>> findByBuTreeId(Long buTreeId);

    /**
     * 通过buTreeId、buId判断组织节点是否存在
     * @param buTreeId
     * @param buId
     * @return
     */
    boolean existsByBuTreeIdAndBuId(Long buTreeId,Long buId);
    /**
     * 通过组织树id和codePathLike查询组织树节点信息
     * @param buTreeId
     * @param codePathLike
     * @return
     */
    List<OrgBuTreeDDO> findAllByBuTreeIdAndCodePathLike(Long buTreeId,String codePathLike);


    /**
     * 根据树id删除节点
     * @param buTreeId 树id
     */
    void deleteByBuTreeId(Long buTreeId);

    List<OrgBuTreeDDO> findByBuIdAndBuTreeId(Long buId,Long buTreeId);
}
