package com.elitescloud.cloudt.system.modules.warning.service.impl;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.common.param.IdNameParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningSceneUdc;
import com.elitescloud.cloudt.system.modules.warning.service.SysWarningRecordMngService;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningRecordDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningRecordDetailDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningRecordNoticeDO;
import com.elitescloud.cloudt.system.modules.warning.service.repo.SysWarningNoticeRepoProc;
import com.elitescloud.cloudt.system.modules.warning.service.repo.SysWarningRecordDetailRepoProc;
import com.elitescloud.cloudt.system.modules.warning.service.repo.SysWarningRecordRepoProc;
import com.elitescloud.cloudt.system.modules.warning.service.repo.SysWarningRuleRepoProc;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRecordDetailPageQueryVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRecordPageQueryVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRecordDetailRespVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRecordPageRespVO;
import com.elitescloud.cloudt.system.service.repo.TenantUserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/3 周三
 */
@Service
public class SysWarningRecordMngServiceImpl extends AbstractSysWarningService implements SysWarningRecordMngService {

    @Autowired
    private SysWarningRecordRepoProc recordRepoProc;
    @Autowired
    private SysWarningRuleRepoProc ruleRepoProc;
    @Autowired
    private SysWarningRecordDetailRepoProc detailRepoProc;
    @Autowired
    private SysWarningNoticeRepoProc noticeRepoProc;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private TenantDataIsolateProvider  tenantDataIsolateProvider;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private TenantUserRepoProc tenantUserRepoProc;
    @Autowired
    private UdcProvider udcProvider;

    @Override
    public ApiResult<PagingVO<SysWarningRecordPageRespVO>> pageQuery(SysWarningRecordPageQueryVO queryVO) {
        var tenant = tenantClientProvider.getCurrentTenant();
        var tenantId = tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId();
        List<Long> userIds = StrUtil.isBlank(queryVO.getReceiver()) ? Collections.emptyList() :
                tenantDataIsolateProvider.byDefaultDirectly(() -> tenantUserRepoProc.queryUserIdByLastname(tenantId, queryVO.getReceiver(), true));

        var pageData = recordRepoProc.pageQuery(queryVO, userIds);
        if (pageData.isEmpty()) {
            return ApiResult.ok(pageData.map(t -> new SysWarningRecordPageRespVO()));
        }

        var ruleCodes = pageData.stream().map(SysWarningRecordDO::getRuleCode).collect(Collectors.toSet());
        var ruleMap = ruleRepoProc.listIdCodeNames(ruleCodes).stream().collect(Collectors.toMap(IdCodeNameParam::getCode, Function.identity(), (t1, t2) -> t1));
        var sceneMap = udcProvider.getValueMapByUdcCode(Application.NAME, SysWarningSceneUdc.UDC_NAME);
        var pageResp = pageData.map(t -> {
            SysWarningRecordPageRespVO respVO = new SysWarningRecordPageRespVO();
            respVO.setId(t.getId());
            respVO.setExecTime(t.getExecTime());
            respVO.setFinishTime(t.getFinishTime());
            respVO.setRuleCode(t.getRuleCode());
            respVO.setRuleName(ruleMap.containsKey(t.getRuleCode()) ? ruleMap.get(t.getRuleCode()).getName() : null);
            respVO.setScene(t.getScene());
            respVO.setSceneName(sceneMap.get(t.getScene()));
            respVO.setNumTotal(t.getNumTotal());
            respVO.setNumSuccess(t.getNumSuccess());
            respVO.setNumFail(t.getNumFail());

            return respVO;
        });
        return ApiResult.ok(pageResp);
    }

    @Override
    public ApiResult<PagingVO<SysWarningRecordDetailRespVO>> getDetail(SysWarningRecordDetailPageQueryVO queryVO) {
        var pageData = detailRepoProc.pageQuery(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok(pageData.map(t -> new SysWarningRecordDetailRespVO()));
        }

        var detailIds = pageData.stream().map(SysWarningRecordDetailDO::getId).collect(Collectors.toSet());
        var noticesMap = noticeRepoProc.listByDetailId(detailIds);
        var userIds = noticesMap.values().stream().flatMap(t -> t.stream().map(SysWarningRecordNoticeDO::getNoticeUserId)).collect(Collectors.toSet());
        Map<Long, IdNameParam> userMap = userIds.isEmpty() ? Collections.emptyMap() : tenantDataIsolateProvider.byDefaultDirectly(() ->
                userRepoProc.queryUserName(userIds).stream().collect(Collectors.toMap(IdNameParam::getId, Function.identity(), (t1, t2) -> t1))
        );

        var pageResp = pageData.map(t -> {
            SysWarningRecordDetailRespVO respVO = new SysWarningRecordDetailRespVO();
            respVO.setId(t.getId());
            respVO.setDocCode(t.getDocCode());
            respVO.setDocName(t.getDocName());
            respVO.setSuccess(t.getVerifyPass());
            respVO.setFailReason(t.getFailReason());
            respVO.setNoticed(false);
            if (noticesMap.containsKey(t.getId())) {
                respVO.setReceivers(noticesMap.get(t.getId()).stream()
                                .filter(tt -> {
                                    if (Boolean.TRUE.equals(t.getVerifyPass())) {
                                        return Boolean.TRUE.equals(tt.getNoticeSent());
                                    }
                                    return true;
                                })
                        .map(t1 -> userMap.get(t1.getNoticeUserId()).getName()).collect(Collectors.joining(",")));
            }
            return respVO;
        });
        return ApiResult.ok(pageResp);
    }

    @Override
    public ApiResult<Boolean> rePush(Long recordDetailId) {
        return ApiResult.ok(true);
    }
}
