package com.elitescloud.cloudt.system.modules.warning.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serial;
import java.time.LocalDateTime;

/**
 * 预警执行记录.
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/4 周一
 */
@Entity
@Table(name = "sys_warning_record", indexes = {
        @Index(name = "idx_warning_record_code", columnList = "ruleCode"),
        @Index(name = "idx_warning_record_exectime", columnList = "execTime"),
        @Index(name = "idx_warning_record_scene", columnList = "scene"),
})
@Comment("预警执行记录")
@Getter
@Setter
public class SysWarningRecordDO extends BaseModel {
    @Serial
    private static final long serialVersionUID = -2053740398889392427L;

    @Comment(value = "规则编码")
    @Column(nullable = false)
    private String ruleCode;

    @Comment(value = "业务场景, [UDC]cloudt-system:WARNING_SCENE")
    @Column(nullable = false)
    private String scene;

    @Comment(value = "执行时间")
    @Column(nullable = false)
    private LocalDateTime execTime;

    @Comment(value = "执行结束时间")
    @Column(nullable = false)
    private LocalDateTime finishTime;

    @Comment(value = "校验结果数", defaultValue = "0")
    @Column()
    private Integer numTotal;

    @Comment(value = "校验成功结果数", defaultValue = "0")
    @Column()
    private Integer numSuccess;

    @Comment(value = "校验失败结果数", defaultValue = "0")
    @Column()
    private Integer numFail;
}
