
package com.elitescloud.cloudt.system.modules.warning.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;

import javax.persistence.*;
import java.io.Serial;
import java.time.LocalDateTime;

/**
 * 预警执行记录明细.
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/6 周三
 */
@Entity
@Table(name = "sys_warning_record_notice", indexes = {
        @Index(name = "idx_warning_record_notice_mas", columnList = "masId"),
})
@Comment("预警执行记录的通知信息")
@Getter
public class SysWarningRecordNoticeDO extends BaseModel {
    @Serial
    private static final long serialVersionUID = 5628270464882186570L;

    @Comment(value = "主表ID")
    @Column(nullable = false)
    private Long masId;

    @Comment(value = "通知的用户ID")
    @Column()
    private Long noticeUserId;

    @Comment(value = "通知的用户账号")
    @Column()
    private String userAccount;

    @Comment(value = "通知的消息模板编码")
    @Column()
    private String noticeTmplCode;

    @Comment(value = "通知的渠道")
    @Column()
    private String noticeChannel;

    @Comment(value = "是否已发送", defaultValue = "0")
    @Column()
    private Boolean noticeSent;

    @Comment(value = "发送时间")
    @Column()
    private LocalDateTime sentTime;

    @Comment(value = "通知内容")
    @Column()
    @Lob
    private String noticeContent;

    @Comment(value = "失败原因")
    @Column()
    private String failReason;
}
