package com.elitescloud.cloudt.system.modules.warning.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.QSysWarningRuleDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.QSysWarningSceneCondDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningSceneCondDO;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/4 周一
 */
@Repository
public class SysWarningScendCondRepoProc extends BaseRepoProc<SysWarningSceneCondDO> {
    private static final QSysWarningSceneCondDO QDO = QSysWarningSceneCondDO.sysWarningSceneCondDO;
    private static final QSysWarningRuleDO QDO_RULE = QSysWarningRuleDO.sysWarningRuleDO;

    public SysWarningScendCondRepoProc() {
        super(QDO);
    }

    public void deleteByRuleCode(@NotBlank String ruleCode) {
        super.deleteByValue(QDO.ruleCode, ruleCode);
    }

    public void deleteByRuleIds(@NotEmpty Collection<Long> ruleIds) {
        var predicate = QDO.ruleCode.in(JPAExpressions.select(QDO_RULE.ruleCode).from(QDO_RULE).where(QDO_RULE.id.in(ruleIds)));
        super.delete(predicate);
    }

    public List<SysWarningSceneCondDO> listByRuleId(long ruleId) {
        var predicate = QDO.ruleCode.in(JPAExpressions.select(QDO_RULE.ruleCode).from(QDO_RULE).where(QDO_RULE.id.eq(ruleId)));
        return super.getList(predicate, QDO.sortNo.asc());
    }
}
