package com.elitescloud.cloudt.system.modules.warning.web.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.warning.service.SysWarningRecordMngService;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRecordDetailPageQueryVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRecordPageQueryVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRecordDetailRespVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRecordPageRespVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/3 周三
 */
@RestController
@RequestMapping(value = "/mng/warning/ruleRecord")
@Api(tags = "预警规则执行记录")
public class SysWarningRecordMngController {

    @Autowired
    private SysWarningRecordMngService sysWarningRecordMngService;

    @ApiOperation(value = "分页查询执行记录")
    @PostMapping(value = "/pageQuery")
    public ApiResult<PagingVO<SysWarningRecordPageRespVO>> pageQuery(@RequestBody SysWarningRecordPageQueryVO queryVO) {
        return sysWarningRecordMngService.pageQuery(queryVO);
    }

    @ApiOperation(value = "分页查询执行记录明细")
    @PostMapping(value = "/pageDetail")
    public ApiResult<PagingVO<SysWarningRecordDetailRespVO>> getDetail(@RequestBody SysWarningRecordDetailPageQueryVO queryVO) {
        return sysWarningRecordMngService.getDetail(queryVO);
    }

    @ApiOperation(value = "重新推送")
    @PostMapping(value = "/rePush")
    public ApiResult<Boolean> rePush(@NotNull @RequestParam(name = "recordId") Long recordDetailId) {
        return sysWarningRecordMngService.rePush(recordDetailId);
    }
}
