package com.elitescloud.cloudt.system.modules.warning.web.model.vo.query;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/3 周三
 */
@Getter
@Setter
@ApiModel(description = "预警规则执行记录分页查询参数")
public class SysWarningRecordPageQueryVO extends AbstractOrderQueryParam {
    @Serial
    private static final long serialVersionUID = -4092060793456624480L;

    @ApiModelProperty(value = "业务场景, [UDC]cloudt-system:WARNING_SCENE")
    private String scene;

    @ApiModelProperty(value = "规则编码")
    private String ruleCode;

    @ApiModelProperty(value = "规则名称")
    private String ruleName;

    @ApiModelProperty(value = "状态：是否成功")
    private Boolean success;

    @ApiModelProperty(value = "执行时间-开始")
    private LocalDateTime execTimeStart;
    @ApiModelProperty(value = "执行时间-截止")
    private LocalDateTime execTimeEnd;

    @ApiModelProperty(value = "接收人")
    private String receiver;
}
