package com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/3 周三
 */
@Getter
@Setter
@ApiModel(description = "预警规则执行记录")
public class SysWarningRecordPageRespVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -6050217664978520683L;

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "执行时间")
    private LocalDateTime execTime;

    @ApiModelProperty(value = "执行结束时间")
    private LocalDateTime finishTime;

    @ApiModelProperty(value = "规则编码")
    private String ruleCode;

    @ApiModelProperty(value = "规则名称")
    private String ruleName;

    @ApiModelProperty(value = "业务场景, [UDC]cloudt-system:WARNING_SCENE")
    private String scene;
    private String sceneName;

    @ApiModelProperty(value = "触发条数")
    private Integer numTotal;

    @ApiModelProperty(value = "成功条数")
    private Integer numSuccess;

    @ApiModelProperty(value = "失败条数")
    private Integer numFail;
}
