package com.elitescloud.cloudt.system.modules.wecom.config;

import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.cloudt.system.modules.wecom.common.WecomUserConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/12/1
 */
@Configuration
public class WecomAuthConfig {

    @Bean
    @ConditionalOnMissingBean
    public WecomUserConverter wecomUserConverterDefault() {
        return (userid, userTicket, accessToken) -> new InternalAuthenticationGranter.InternalAuthenticationToken(InternalAuthenticationGranter.IdType.USER_ID, userid);
    }
}
