package com.elitescloud.cloudt.system.modules.wecom.model.user.attr;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 网页属性.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/21
 */
@Getter
@Setter
public class WebAttr extends BaseAttr {
    private static final long serialVersionUID = 3080134091659472513L;

    /**
     * web信息
     */
    private Web web;

    /**
     * 创建实例
     *
     * @param name
     * @param title
     * @param url
     * @return
     */
    public static WebAttr create(String name, String title, String url) {
        WebAttr.Web web1 = new WebAttr.Web();
        web1.setUrl(url);
        web1.setTitle(title);

        WebAttr attr = new WebAttr();
        attr.setWeb(web1);
        attr.setType(1);
        attr.setName(name);
        return attr;
    }

    @Getter
    @Setter
    public static class Web implements Serializable {
        private static final long serialVersionUID = 6063577830706567616L;

        /**
         * url地址
         */
        private String url;

        /**
         * 标题
         */
        private String title;
    }
}
