package com.elitescloud.cloudt.system.rest;

//import com.alibaba.csp.sentinel.annotation.SentinelResource;
//import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * 测试熔断 限流,流控等
 */
@Slf4j
@RestController
@Api(value = "【测试】sentinel测试", tags = {"【测试】熔断,限流"})
@RequestMapping("/sentinel")
public class SentinelTestController {

    @GetMapping("/getFirstSentinel")
    @ApiOperation(value = "获取第一个对象")
    public ApiResult<Object> getFirstSentinel(){

        return ApiResult.ok("hello sentinel");
    }

    /**
     * 按资源名称限流，需要指定限流处理逻辑
     */
    @GetMapping("/byResource")
//    @SentinelResource(value = "byResource",blockHandler = "handleException")
    public ApiResult<Object> byResource() {

        return ApiResult.ok("按资源名称限流");
    }

    @GetMapping("/degrade/{id}")
    @ApiOperation(value = "降级处理")
//    @SentinelResource(value = "degrade", blockHandler = "degradeException")
    public ApiResult<Object> degrade(@PathVariable Long id){

        try {
            Thread.sleep(25);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        return ApiResult.ok("降级测试,正常返回!!!");
    }

    @GetMapping("/param-flow")
    @ResponseBody
    @ApiOperation(value = "测试热点规则", notes = "测试热点规则")
//    @SentinelResource(value = "paramFlow", blockHandler = "paramException")
    public ApiResult<Object> paramFlow(
            //项目uuid
            @ApiParam(name = "projectUuid", value = "项目uuid" , required = false)
            @RequestParam(value = "projectUuid", required = false) String projectUuid,
            //测试uuid
            @ApiParam(name = "testUuid", value = "查询参数" , required = false)
            @RequestParam(value = "testUuid", required = false) String testUuid,
            //整数使用
            @ApiParam(name = "useInt", value = "整数使用" , required = false)
            @RequestParam(value = "useInt", required = false) Integer useInt
    ){

        log.info("projectUuid==="+projectUuid+",testUuid==="+testUuid+",useInt==="+useInt);

        return ApiResult.ok("热点规则,正常返回!!!");
    }

    /**
     * 按资源名称限流，需要指定限流处理逻辑  触犯规则执行方法
     * @param exception
     * @return
     */
//    public ApiResult handleException(BlockException exception){
//        return ApiResult.fail(exception.getClass().getCanonicalName());
//    }

    /**
     * 降级处理 触犯规则执行方法
     * @param id
     * @param exception
     * @return
     */
//    public ApiResult degradeException(Long id,BlockException exception){
//
//        return ApiResult.fail("被确定降级了!!!");
//    }

    /**
     * 热点参数规则触犯执行方法
     * @param projectUuid
     * @param testUuid
     * @param useInt
     * @param exception
     * @return
     */
//    public ApiResult paramException(String projectUuid,String testUuid,Integer useInt,BlockException exception){
//        log.info("paramException projectUuid==="+projectUuid+",testUuid==="+testUuid+",useInt==="+useInt);
//        return ApiResult.fail("热点规则异常出现!!!");
//    }
}
