package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.SysApiPermissionRpcService;
import com.elitescloud.cloudt.system.provider.dto.SysApiPermissionMetadataDTO;
import com.elitescloud.cloudt.system.provider.param.ApiPermissionQueryDTO;
import com.elitescloud.cloudt.system.service.PermissionQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/11/7
 */
@RestController
@RequestMapping(value = SysApiPermissionRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysApiPermissionRpcServiceImpl implements SysApiPermissionRpcService {

    @Autowired
    private PermissionQueryService apiPermissionQueryService;

    @Override
    public ApiResult<List<SysApiPermissionMetadataDTO>> queryPermissionMetadata(String appCode, String tenantCode) {
        return apiPermissionQueryService.queryApiMetadata(appCode);
    }

    @Override
    public ApiResult<List<SysApiPermissionMetadataDTO>> queryPermissionMetadata(ApiPermissionQueryDTO queryDTO) {
        return ApiResult.ok(Collections.emptyList());
    }
}
