package com.elitescloud.cloudt.system.rpc.org;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.dto.SysEmpGroupDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeGroupRpcService;
import com.elitescloud.cloudt.system.service.EmpGroupQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
@RestController
@RequestMapping(value = EmployeeGroupRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class EmployeeGroupRpcServiceImpl implements EmployeeGroupRpcService {

    private EmpGroupQueryService queryService;

    @Override
    public ApiResult<SysEmpGroupDTO> getByCode(String groupCode) {
        return queryService.getByCode(groupCode);
    }

    @Override
    public ApiResult<SysEmpGroupDTO> getById(Long groupId) {
        return queryService.get(groupId);
    }

    @Override
    public ApiResult<List<SysEmpGroupDTO>> listAll() {
        return queryService.listAll();
    }

    @Override
    public ApiResult<List<Long>> getUserIdsByGroupCode(String groupCode) {
        return queryService.getUserIdsByGroupCode(groupCode);
    }

    @Override
    public ApiResult<Map<String, List<Long>>> queryUserIdsByGroupCodes(Set<String> groupCodes) {
        return queryService.queryUserIdsByGroupCodes(groupCodes);
    }

    @Override
    public ApiResult<Map<String, List<IdCodeNameParam>>> queryUsersByGroupCodes(Set<String> groupCodes) {
        return queryService.queryUsersByGroupCodes(groupCodes);
    }

    @Autowired
    public void setQueryService(EmpGroupQueryService queryService) {
        this.queryService = queryService;
    }
}
