package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.vo.extend.query.CurrencyPageQueryVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.CurrencyPageRespVO;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/31
 */
public interface CurrencyMngService {

    /**
     * 分页查询货币
     *
     * @param queryVO 查询参数
     * @return 货币列表
     */
    ApiResult<PagingVO<CurrencyPageRespVO>> page(CurrencyPageQueryVO queryVO);

    /**
     * 切换启用禁用
     *
     * @param id 货币ID
     * @return 切换结果
     */
    ApiResult<Long> execSwitchEnabled(Long id);
}
