package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.CurrencyRatePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.CurrencyRateDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.CurrencyRatePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.CurrencyRateSaveVO;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/31
 */
public interface CurrencyRateMngService {

    /**
     * 保存汇率
     *
     * @param saveVO 汇率信息
     * @return 汇率ID
     */
    ApiResult<Long> save(CurrencyRateSaveVO saveVO);

    /**
     * 删除汇率信息
     *
     * @param id 汇率ID
     * @return 汇率ID
     */
    ApiResult<Long> delete(Long id);

    /**
     * 切换启用禁用
     *
     * @param id 汇率ID
     * @return 切换结果
     */
    ApiResult<Long> updateEnabled(Long id);

    /**
     * 分页查询汇率
     *
     * @param queryVO 查询参数
     * @return 汇率列表
     */
    ApiResult<PagingVO<CurrencyRatePageRespVO>> page(CurrencyRatePageQueryVO queryVO);

    /**
     * 获取汇率详情
     *
     * @param id 汇率ID
     * @return 汇率详情
     */
    ApiResult<CurrencyRateDetailRespVO> get(Long id);
}
