package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.query.datarelation.DataRelationInstEditQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationConfigRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationInstEditRespVO;
import com.elitescloud.cloudt.system.model.vo.save.datarelation.DataRelationInstSaveVO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/15
 */
public interface DataRelationInstMngService {

    /**
     * 获取数据关系的配置
     *
     * @param drCode
     * @return
     */
    ApiResult<DataRelationConfigRespVO> getConfig(@NotBlank String drCode);

    /**
     * 保存配置的值
     *
     * @param saveVO 保存信息
     * @return
     */
    ApiResult<Boolean> saveValues(@NotNull DataRelationInstSaveVO saveVO);

    /**
     * 获取数据编辑信息
     *
     * @param queryVO
     * @return
     */
    ApiResult<DataRelationInstEditRespVO> getValues(@NotNull DataRelationInstEditQueryVO queryVO);
}
