package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.sys.DataSelectorPagedQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.DataSelectorDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.DataSelectorGroupDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.DataSelectorPagedRespVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.DataSelectorGroupSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.DataSelectorSaveVO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/16
 */
public interface DataSelectorMngService {

    /**
     * 保存分组信息
     *
     * @param saveVO 分组信息
     * @return 分组ID
     */
    ApiResult<Long> saveGroup(@NotNull DataSelectorGroupSaveVO saveVO);

    /**
     * 删除分组
     *
     * @param groupCode 分组编码
     * @return 删除结果
     */
    ApiResult<String> deleteGroup(@NotBlank String groupCode);

    /**
     * 修改启用状态
     *
     * @param groupCode 分组编码
     * @param enabled   启用状态
     * @return 分组ID
     */
    ApiResult<String> updateGroupEnabled(@NotBlank String groupCode, Boolean enabled);

    /**
     * 修改名称
     *
     * @param groupCode 分组编码
     * @param name      分组名称
     * @return 分组ID
     */
    ApiResult<String> updateGroupName(@NotBlank String groupCode, String name);

    /**
     * 获取分组详细信息
     *
     * @param groupCode 分组编码
     * @return 分组详细信息
     */
    ApiResult<DataSelectorGroupDetailRespVO> getGroupDetail(@NotBlank String groupCode);

    /**
     * 获取分组列表
     *
     * @return 分组列表
     */
    ApiResult<List<IdCodeNameParam>> listGroup();

    /**
     * 保存选择器
     *
     * @param saveVO 选择器信息
     * @return 选择器ID
     */
    ApiResult<Long> save(DataSelectorSaveVO saveVO);

    /**
     * 获取选择器详细信息
     *
     * @param id 选择器ID
     * @return 选择器详细信息
     */
    ApiResult<DataSelectorDetailRespVO> getDetail(Long id);

    /**
     * 分页查询选择器
     *
     * @param queryVO 查询参数
     * @return 选择器列表
     */
    ApiResult<PagingVO<DataSelectorPagedRespVO>> pageMng(DataSelectorPagedQueryVO queryVO);

    /**
     * 修改启用状态
     *
     * @param id      选择器ID
     * @param enabled 状态
     * @return 选择器ID
     */
    ApiResult<Long> updateEnabled(Long id, Boolean enabled);

    /**
     * 批量删除选择器
     *
     * @param ids 选择器ID
     * @return 删除结果
     */
    ApiResult<Boolean> delete(List<Long> ids);
}
