package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.SysSendVerifyCodeVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.index.*;
import com.elitescloud.cloudt.system.model.vo.save.index.ModifyPasswordSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.index.PasswordUpdateSaveVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;

import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 首页用户服务.
 *
 * @author Kaiser（wang shao）
 * 2022/10/17
 */
public interface IndexUserService {

    /**
     * 获取当前用户的员工信息
     *
     * @return 员工详细信息
     */
    ApiResult<CurrentEmployeeRespVO> getEmployeeInfo();

    /**
     * 修改自己的密码
     * <p>
     * 登录后根据老密码验证通过后修改当前密码
     *
     * @param saveVO 密码信息
     * @return 修改结果
     */
    ApiResult<Boolean> updatePassword(ModifyPasswordSaveVO saveVO);

    /**
     * 修改密码（发送验证码）
     *
     * @param verifyCodeParam 验证码信息
     * @return 发送结果
     */
    ApiResult<String> sendVerifyCodeForUpdatePwd(boolean retrieve, SysSendVerifyCodeVO verifyCodeParam);

    /**
     * 修改密码（根据验证码）
     *
     * @param saveVO
     * @return
     */
    ApiResult<Long> updatePwdByVerifyCode(boolean retrieve, PasswordUpdateSaveVO saveVO);

    /**
     * 获取当前用户的菜单
     *
     * @param tree 是否展示树状
     * @return 菜单列表
     */
    ApiResult<List<UserMenuRespVO>> getUserMenu(String terminal, Boolean includeAction, Boolean tree, Boolean cacheable);

    /**
     * 获取当前用户的按钮
     *
     * @param menuCode 菜单编码，为空则获取所有按钮
     * @return 按钮列表
     */
    ApiResult<List<UserMenuRespVO>> getUserAction(String menuCode);

    /**
     * 获取当前用户授权的字段
     *
     * @param menuCode 菜单编码
     * @param apiCode  API接口编码
     * @return 字段列表
     */
    ApiResult<List<UserFieldRespVO>> getUserField(@NotBlank String menuCode, @NotBlank String apiCode);

    /**
     * 获取用户的前端表格配置
     *
     * @param tableCode 表格编码
     * @return 配置内容
     */
    ApiResult<String> getFrontTableCfg(@NotBlank String tableCode);

    /**
     * 切换用户的当前租户
     *
     * @param tenantId 租户ID
     * @return 切换结果
     */
    ApiResult<SysUserDTO> switchTenant(@NotNull Long tenantId);

    /**
     * 切换用户的当前组织
     *
     * @param orgId 组织ID
     * @return 切换结果
     */
    ApiResult<SysUserDTO> switchOrg(@NotNull Long orgId);

    /**
     * 获取数据权限
     *
     * @return 数据权限
     */
    ApiResult<UserDataPermissionRespVO> getDataPermission(Boolean all, Boolean reload);

    /**
     * 获取当前的字段权限
     *
     * @return 字段权限列表
     */
    ApiResult<List<AuthedUserFieldRespVO>> getFieldPermission();

    /**
     * 获取用户的OpenID
     *
     * @param request request
     * @param outerAppId 外部应用标识
     * @return
     */
    ApiResult<String> getOpenId(HttpServletRequest request, String outerAppId);

    /**
     *
     * @param outerAppId
     * @return
     */
    ApiResult<String> unbindOpenId(@NotBlank String outerAppId);
}
