package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.sys.OpenApiOperationPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.sys.OpenApiPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.OpenApiOperationPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.OpenApiPageRespVO;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiSourceEnum;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * OpenAPI管理接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/4
 */
public interface OpenApiMngService {

    /**
     * 测试分析controller
     *
     * @param beanClasses controller的类class
     * @return 解析结果
     */
    ApiResult<OpenAPI> testAnalyzeController(Class<?>... beanClasses);

    /**
     * 更新OpenApi信息
     *
     * @param appCode 应用编码
     * @return OpenApi信息ID
     */
    ApiResult<Long> updateOpenApi(@NotBlank String appCode);

    /**
     * 更新OpenApi信息
     *
     * @param openApiId OpenApi信息ID
     * @return OpenApi信息ID
     */
    ApiResult<Long> updateOpenApi(@NotNull Long openApiId);

    /**
     * 更新OpenApi信息
     *
     * @param openApi 应用的OpenApi信息
     * @param source  数据来源
     * @return OpenApi信息ID
     */
    ApiResult<Long> updateOpenApi(@NotNull OpenAPI openApi, @NotNull OpenApiSourceEnum source);

    /**
     * 分页查询管理
     *
     * @param queryVO 查询参数
     * @return 分页结果
     */
    ApiResult<PagingVO<OpenApiPageRespVO>> pageMng(OpenApiPageQueryVO queryVO);

    /**
     * 分页查询管理
     *
     * @param queryVO 查询参数
     * @return 分页结果
     */
    ApiResult<PagingVO<OpenApiOperationPageRespVO>> pageMng(OpenApiOperationPageQueryVO queryVO);

    /**
     * 获取全部操作的分组数据
     * **/
    ApiResult<List<String>> selectDistinctOperationGroupByApiType();

}
