package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysUdcDTO;
import com.elitescloud.cloudt.system.model.vo.query.udc.UdcPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcWithValuesPageRespVO;

import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/24
 */
public interface UdcQueryService {

    /**
     * 获取UDC项
     *
     * @param appCode 应用编码
     * @param udcCode UDC编码
     * @return udc
     */
    ApiResult<SysUdcDTO> get(String appCode, String udcCode);

    /**
     * 获取UDC列表
     *
     * @param appCode  应用编码
     * @param udcCodes UDC编码列表
     * @return UDC列表
     */
    ApiResult<List<SysUdcDTO>> listByUdcCode(String appCode, Set<String> udcCodes);

    /**
     * 分页查询UDC
     *
     * @param queryVO 查询参数
     * @return UDC列表
     */
    ApiResult<PagingVO<UdcWithValuesPageRespVO>> pageQuery(UdcPageQueryVO queryVO);
}
