package com.elitescloud.cloudt.system.service.alert;

import com.elitescloud.cloudt.system.constant.SysAlertType;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertConfigBaseRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.AlertConfigBaseSaveVO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Map;

/**
 * 提醒方式.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
public interface AlertProvider<T extends AlertConfigBaseSaveVO, R extends AlertConfigBaseRespVO> {
    String CATEGORY_DEFAULT = "default";

    /**
     * 提醒类型
     *
     * @return 提醒类型
     */
    SysAlertType alertType();

    /**
     * 转为字符串
     *
     * @return 字符串
     */
    String toString(@NotNull T saveVO);

    /**
     * 解析字符串
     *
     * @param cfgJson json字符串
     * @return 对象
     */
    R parse(@NotBlank String cfgJson);

    /**
     * 发送
     *
     * @param cfgJson  配置内容
     * @param content  预警内容
     * @param category 配置分类
     */
    boolean send(@NotBlank String cfgJson, @NotBlank String content, String category);

    /**
     * 根据模板发送
     *
     * @param cfgJson    配置内容
     * @param tmplParams 模板参数
     * @param category   配置分类
     */
    boolean sendByTmpl(@NotBlank String cfgJson, @NotEmpty Map<String, Object> tmplParams, String category);
}
