package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.system.constant.SysAlertType;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertConfigBaseRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.AlertConfigBaseSaveVO;
import com.elitescloud.cloudt.system.service.alert.AlertProvider;
import com.elitescloud.cloudt.system.service.alert.DingdingAlertProvider;
import com.elitescloud.cloudt.system.service.alert.WxWorkAlertProvider;
import com.elitescloud.cloudt.system.service.repo.AlertConfigRepoProc;
import com.elitescloud.cloudt.system.service.repo.AlertRepoProc;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
class BaseAlertServiceImpl extends BaseServiceImpl implements InitializingBean {

    private final Map<SysAlertType, AlertProvider<? extends AlertConfigBaseSaveVO, ? extends AlertConfigBaseRespVO>> alertProviderMap = new HashMap<>(8);

    @Autowired
    protected AlertRepoProc alertRepoProc;
    @Autowired
    protected AlertConfigRepoProc alertConfigRepoProc;

    @Override
    public void afterPropertiesSet() throws Exception {
        addAlertProvider(new WxWorkAlertProvider(redisUtils));
        addAlertProvider(new DingdingAlertProvider(redisUtils));
    }

    /**
     * 获取提供者
     *
     * @param alertType
     * @return
     */
    public AlertProvider<? extends AlertConfigBaseSaveVO, ? extends AlertConfigBaseRespVO> getAlertProvider(SysAlertType alertType) {
        return alertProviderMap.get(alertType);
    }

    private void addAlertProvider(AlertProvider<?, ?> alertProvider) {
        Assert.notNull(alertProvider.alertType(), "提醒类型为空：{}", alertProvider.getClass().getName());

        alertProviderMap.put(alertProvider.alertType(), alertProvider);
    }
}
