package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.system.common.AuthMethod;
import com.elitescloud.cloudt.system.model.vo.resp.extend.BasicAuthAccountVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.HttpParam;
import com.elitescloud.cloudt.system.service.SecurityAuthService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:44
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
//@UnicomTag("BASIC_AUTH")
public class BasicAuthSecurityService implements SecurityAuthService {
    @Override
    public boolean authentication(WebClient.RequestBodySpec uri, HttpParam param) {
        log.info("[BPMN][INFINITY] Auth Method: " + AuthMethod.AUTH_METHOD_BASIC_AUTH.getDesc());
        BasicAuthAccountVO account = param.getApiConfig().getBasicAuthAccount();
        if (ObjectUtil.isNull(account) || account.isEmpty()) {
            log.error("[BPMN][INFINITY] account is empty.");
            throw new RuntimeException("account is empty.");
        }
        log.info("[BPMN][INFINITY] BasicAuth username: " + account.getUsername());
        uri.headers(headers -> headers.setBasicAuth(account.getUsername(), account.getPassword()));
        return true;
    }

    @Override
    public String getAuthType() {
        return AuthMethod.AUTH_METHOD_BASIC_AUTH.getCode();
    }
}
