package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.ListUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.common.LoggingProperty;
import com.elitescloud.cloudt.system.common.TrackDoc;
import com.elitescloud.cloudt.system.model.entity.TrackDocDeleteParamVO;
import com.elitescloud.cloudt.system.model.vo.AuditLogVO;
import com.elitescloud.cloudt.system.model.vo.AuditQueryParamVO;
import com.elitescloud.cloudt.system.model.vo.TrackDocQueryParamVO;
import com.elitescloud.cloudt.system.model.vo.TrackDocRespVO;
import com.elitescloud.cloudt.system.service.PipelineService;
import com.elitescloud.cloudt.system.util.BeanUtils;
//import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:37
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
//@UnicomTag("CONSOLE")
public class ConsolePipelineService implements PipelineService {
    @Override
    public boolean consume(LoggingProperty property, TrackDoc trackDoc) {
        try {
            log.info("[PHOENIX-LOG] CONSOLE({}): {}", trackDoc.getTrackType(), BeanUtils.toJsonStr(trackDoc));
            return true;
        } catch (Throwable throwable) {
            log.error("[PHOENIX-LOG] persistence console error", throwable);
        }
        return false;
    }

    @Override
    public PagingVO<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query) {
        // do nothing.
        return new PagingVO<>();
    }

    @Override
    public List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query) {
        // do nothing.
        return ListUtil.empty();
    }

    @Override
    public long trackDocDelete(TrackDocDeleteParamVO paramVO) {
        // do nothing.
        return 0;
    }

    @Override
    public List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query) {
        // do nothing.
        return ListUtil.empty();
    }
}
