package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.InfinityFolderConvert;
import com.elitescloud.cloudt.system.model.entity.InfinityFolderDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.FolderSaveParamVO;
import com.elitescloud.cloudt.system.service.InfinityFolderService;
import com.elitescloud.cloudt.system.service.repo.InfinityFolderRepo;
import com.elitescloud.cloudt.system.service.repo.InfinityFolderRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 17:52
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
@TenantTransaction(isolateType = TenantIsolateType.TENANT)
public class InfinityFolderServiceImpl implements InfinityFolderService {

    private final InfinityFolderRepo folderRepo;
    private final InfinityFolderRepoProc folderRepoProc;

    @Autowired
    private TenantClientProvider tenantClientProvider;

    private long currentTenantId() {
        var tenant = tenantClientProvider.getSessionTenant();
        if (tenant == null) {
            tenant = tenantClientProvider.getCurrentTenant();
        }
        return tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long save(FolderSaveParamVO saveParam) {
        // 新增
        if (saveParam.isNew()) {
            // TODO 目录名称唯一
            InfinityFolderDO infinityFolderDO = InfinityFolderConvert.INSTANCE.saveParamToDO(saveParam);
            infinityFolderDO.setTenantId(currentTenantId());
            folderRepo.save(infinityFolderDO);
            return infinityFolderDO.getId();
        }
        // 修改
        else {
            Optional<InfinityFolderDO> infinityFolderDO = folderRepo.findById(saveParam.getId());
            if (infinityFolderDO.isEmpty()) {
                throw new BusinessException("Not Found Data");
            }
            InfinityFolderDO infinityFolder = infinityFolderDO.get();
            InfinityFolderConvert.INSTANCE.saveParamMergeToDO(saveParam, infinityFolder);
            infinityFolder.setTenantId(currentTenantId());
            folderRepo.save(infinityFolder);
            return infinityFolder.getId();
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long delete(List<Long> ids) {
        // TODO 删除该目录下，所有接口
        return folderRepoProc.delete(ids);
    }
}
