package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.elitescloud.cloudt.system.common.LoggingProperty;
import com.elitescloud.cloudt.system.common.TrackDoc;
import com.elitescloud.cloudt.system.model.vo.AuditLogVO;
import com.elitescloud.cloudt.system.service.AuditLogListener;
import com.elitescloud.cloudt.system.service.PersistenceService;
import com.elitescloud.cloudt.system.service.PipelineService;
import com.elitescloud.cloudt.system.service.TenantAsyncSpi;
import com.elitescloud.cloudt.system.util.BpmnTraceUtil;
import com.elitescloud.cloudt.system.util.DateUtils;
import com.elitescloud.cloudt.system.util.HttpServletUtil;
import com.elitescloud.cloudt.system.util.RequestWrapper;
//import com.elitesland.cbpl.unicom.annotation.UnicomTag;
//import com.elitesland.cbpl.unicom.domain.InvokeTag;
//import com.elitesland.cbpl.unicom.util.UnicomClient;
//import com.lzhpo.tracer.util.TracerUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.function.Consumer;

import static com.elitescloud.cloudt.system.util.HttpServletUtil.currentRequestWrapper;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:04
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
//@UnicomTag(InvokeTag.TAG_GENERAL)
public class PersistenceServiceImpl implements PersistenceService {
    @Resource
    private TenantAsyncSpi tenantAsyncSpi;

    @Override
    public <T> void addSystemLogs(LoggingProperty property, String trackType, String eventMessage, List<T> eventParam
            , String eventError) {
        Consumer<Object> addSystemLog = param -> write(property, currentRequestWrapper(), trackType, eventMessage,
                param, eventError);
        // 提交日志至线程池
        if (property.isThreadPool()) {
            if (tenantAsyncSpi == null) {
                // TODO 使用其他默认线程方法
                eventParam.forEach(addSystemLog);
            } else {
                tenantAsyncSpi.runAsync(() -> eventParam.forEach(addSystemLog));
            }
        }
        // 主线程执行
        else {
            eventParam.forEach(addSystemLog);
        }
    }

    @Override
    public <T> void addSystemLog(LoggingProperty property, RequestWrapper request, String trackType,
                                 String eventMessage, T eventParam, String eventError) {
        // 提交日志至线程池
        if (property.isThreadPool()) {
            if (tenantAsyncSpi == null) {
                // TODO 使用其他默认线程方法
                write(property, request, trackType, eventMessage, eventParam, eventError);
            } else {
                tenantAsyncSpi.runAsync(() -> write(property, request, trackType, eventMessage, eventParam,
                        eventError));
            }
        }
        // 主线程执行
        else {
            write(property, request, trackType, eventMessage, eventParam, eventError);
        }
    }

    @Autowired(required = false)
    private AuditLogListener auditLogListener;

    private final PipelineService pipelineService;

    private void write(LoggingProperty property, RequestWrapper request, String trackType, String eventMessage,
                       Object eventParam, String eventError) {
        if (ObjectUtil.isNull(property.getLogType())) {
            log.error("[PHOENIX-LOG] EVENT({}) 日志类型未正确配置：{}", trackType, property);
            return;
        }
        if (ObjectUtil.isNull(property.getConsumerPipeline())) {
            log.error("[PHOENIX-LOG] EVENT({}) 日志消费方式未指定：{}", trackType, property);
            return;
        }
        String logType = property.getLogType().getCode();
        String pipeline = property.getConsumerPipeline().getCode();
        if (!property.isEnabled()) {
            log.warn("[PHOENIX-LOG] EVENT({}) {} 功能未开启.", trackType, logType);
            return;
        }

        // 构建日志记录内容
        TrackDoc trackDoc = new TrackDoc();
        if (ObjectUtil.isNotNull(request)) {
            trackDoc.setRequestUrl(request.getRequestURL().toString());
            trackDoc.setRequestMethod(request.getMethod());
            trackDoc.setRequestHeader(HttpServletUtil.getHeaders(request));
            trackDoc.setRequestParams(HttpServletUtil.getParameters(request));
            trackDoc.setRequestBody(request.getBodyString());
            trackDoc.setAddressIp(ServletUtil.getClientIP(request));
        }
//        String traceId = StrUtil.blankToDefault(BpmnTraceUtil.getTraceId(), TracerUtils.getTraceId());
//        trackDoc.setTraceId(traceId);
//        trackDoc.setGlobalTraceId(TracerUtils.getTraceId());
        trackDoc.setTrackType(trackType);
        trackDoc.setCreateTime(DateUtils.nowStr());
        trackDoc.setEventMessage(eventMessage);
        trackDoc.setEventParam(eventParam);
        trackDoc.setErrorMessage(eventError);

        int maxRetryTimes = property.getRetry().getRetryTimes();
        // 发送日志本地监听
        boolean iOperationLogGetResult = false;
        if (auditLogListener != null && eventParam instanceof AuditLogVO) {
            for (int retryTimes = 0; retryTimes <= maxRetryTimes; retryTimes++) {
                try {
                    iOperationLogGetResult = auditLogListener.createLog((AuditLogVO) eventParam);
                    if (iOperationLogGetResult) {
                        break;
                    }
                } catch (Throwable throwable) {
                    log.error("[PHOENIX-LOG] send auditLog error", throwable);
                }
            }
            if (!iOperationLogGetResult) {
                auditLogListener.operationLogGetErrorHandler();
            }
        }

        // 发送消息管道
        boolean pipelineServiceResult = false;
        for (int retryTimes = 0; retryTimes <= maxRetryTimes; retryTimes++) {
//            try {
//                pipelineServiceResult = UnicomClient.supply(() -> pipelineService.consume(property, trackDoc),
//                        pipeline);
//                if (pipelineServiceResult) {
//                    break;
//                }
//            } catch (Throwable throwable) {
//                log.error("[PHOENIX-LOG] send persistence error", throwable);
//            }
        }
        if (!pipelineServiceResult && auditLogListener != null) {
            auditLogListener.pipelineErrorHandler();
        }
    }
}
