package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.system.common.LoggingProperties;
import com.elitescloud.cloudt.system.service.PersistenceService;
import com.elitescloud.cloudt.system.service.SysLogService;
import com.elitescloud.cloudt.system.util.ExceptionUtils;
import org.springframework.stereotype.Service;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 17:33
 * @Description:
 */
@Service
public class SysLogServiceImpl implements SysLogService {
    private final PersistenceService persistenceService;

    public void info(String trackType, String message, Object eventParam) {
        this.persistenceService.addSystemLog(LoggingProperties.LOG_SYSLOG_CFG, trackType, message, eventParam, "");
    }

    public void error(String trackType, String message, Object eventParam, Throwable ex) {
        this.persistenceService.addSystemLog(LoggingProperties.LOG_SYSLOG_CFG, trackType, message, eventParam,
                ExceptionUtils.formatException(ex));
    }

    public void error(String trackType, String message, Object eventParam, String trackTypeError) {
        this.persistenceService.addSystemLog(LoggingProperties.LOG_SYSLOG_CFG, trackType, message, eventParam,
                trackTypeError);
    }

    public SysLogServiceImpl(final PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}
