package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.service.callback.UserChangedCallback;
import com.elitescloud.cloudt.system.service.manager.EmployeeMngManager;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

import java.util.function.Supplier;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/11
 */
@Slf4j
@Service
public class UserChangedCallbackEmployeeServiceImpl implements UserChangedCallback {
    public static final String ATTRIBUTE_SOURCE = "cloudtSystemUserChanged";
    public static final String ATTRIBUTE_SOURCE_VALUE_EMPLOYEE = "employee";

    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private EmployeeMngManager employeeMngManager;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private TaskExecutor taskExecutor;

    @Override
    public void onUpsert(boolean add, SysUserSaveBO saveBO, SysUserDO userDO) {
        if (fromEmployee()) {
            return;
        }
        this.detectTenant(() -> {
            var employeeDO = employeeRepoProc.getByUserId(userDO.getId()).orElse(null);
            if (employeeDO == null) {
                return null;
            }

            employeeDO.setUsername(userDO.getUsername());
            employeeDO.setLastName(userDO.getLastName());
            employeeDO.setFirstName(userDO.getFirstName());
            employeeDO.setGender(userDO.getGender());
            employeeDO.setNickName(userDO.getNickName());
            employeeDO.setBirthDate(userDO.getBirthDate());
            employeeDO.setMobile(userDO.getMobile());
            employeeDO.setEmail(userDO.getEmail());
            employeeDO.setIdCard(userDO.getIdCard());
            employeeDO.setCountryCode(userDO.getCountryCode());
            employeeDO.setProvinceCode(userDO.getProvinceCode());
            employeeDO.setCityCode(userDO.getCityCode());
            employeeDO.setCountyCode(userDO.getCountyCode());
            employeeDO.setAddress(userDO.getAddress());
            employeeDO.setPersonalSign(userDO.getPersonalSign());
            employeeDO.setAvatarUrl(userDO.getAvatarUrl());
            employeeDO.setAvatarCode(userDO.getAvatarCode());
            employeeRepoProc.save(employeeDO);
            return null;
        });
    }

    @Override
    public void onEnabled(Long userId, boolean enabled) {
        if (fromEmployee()) {
            return;
        }
        this.detectTenant(() -> {
            employeeRepoProc.updateEnabledByUserId(userId, enabled);
            return null;
        });
    }

    @Override
    public void onUpdatePassword(Long userId, String password, String originalPassword) {

    }

    @Override
    public void onUpdateMobile(Long userId, String mobile) {

    }

    @Override
    public void onUpdateEmail(Long userId, String email) {

    }

    @Override
    public void onDelete(Long userId, Long casUserIdLong) {
        if (fromEmployee()) {
            return;
        }
        this.detectTenant(() -> {
            employeeMngManager.deleteEmployeeByUser(userId);
            return null;
        });
    }

    private void detectTenant(Supplier<Void> supplier) {
        var tenant = tenantClientProvider.getCurrentTenant();
        taskExecutor.execute(() -> {
            if (tenant == null) {
                tenantDataIsolateProvider.byAllTenant(supplier);
                return;
            }

            tenantDataIsolateProvider.byTenantDirectly(supplier, tenant);
        });
    }

    private boolean fromEmployee() {
        var request = HttpServletUtil.currentRequest();
        if (request == null) {
            return false;
        }
        return ATTRIBUTE_SOURCE_VALUE_EMPLOYEE.equals(request.getAttribute(ATTRIBUTE_SOURCE));
    }
}
