package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformApiParameterDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiParameterDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 3/29/2023
 */
@Repository
public class ApiParameterRepoProc extends BaseRepoProc<SysPlatformApiParameterDO> {
    private static final QSysPlatformApiParameterDO QDO = QSysPlatformApiParameterDO.sysPlatformApiParameterDO;

    public ApiParameterRepoProc() {
        super(QDO);
    }

    /**
     * 根据接口编号查询出参的字段
     *
     * @param apiCode 接口编码
     * @return 字段名称
     */
    public List<CodeNameParam> queryOutParamByApiCode(@NotBlank String apiCode) {
        return super.jpaQueryFactory.select(QDO.fieldName, QDO.fieldExplain)
                .from(QDO)
                .where(QDO.apiCode.eq(apiCode).and(QDO.inOutType.eq(SysPlatformApiParameterDO.TYPE_OUT)))
                .fetch()
                .stream()
                .map(t -> new CodeNameParam(t.get(QDO.fieldName), t.get(QDO.fieldExplain)))
                .collect(Collectors.toList());
    }

    /**
     * 根据接口编号查询入参的字段
     *
     * @param apiCode 接口编码
     * @return 字段名称
     */
    public List<CodeNameParam> queryInParamByApiCode(@NotBlank String apiCode) {
        return super.jpaQueryFactory.select(QDO.fieldName, QDO.fieldExplain)
                .from(QDO)
                .where(QDO.apiCode.eq(apiCode).and(QDO.inOutType.eq(SysPlatformApiParameterDO.TYPE_IN)))
                .fetch()
                .stream()
                .map(t -> new CodeNameParam(t.get(QDO.fieldName), t.get(QDO.fieldExplain)))
                .collect(Collectors.toList());
    }
}
