package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.cloudt.system.service.model.entity.QSysOpenApiResourceDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiResourceDO;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/6
 */
@Repository
public class OpenApiResourceRepoProc extends BaseRepoProc<SysOpenApiResourceDO> {
    private static final QSysOpenApiResourceDO QDO = QSysOpenApiResourceDO.sysOpenApiResourceDO;

    public OpenApiResourceRepoProc() {
        super(QDO);
    }

    /**
     * 删除数据
     *
     * @param openApiId
     */
    @Transactional(rollbackFor = Exception.class)
    public void deleteByOpenApiId(long openApiId) {
        super.delete(QDO.openApiInfoId.eq(openApiId));
    }

    /**
     * 根据OpenApiId获取所有资源
     *
     * @param openApiId
     * @return
     */
    public List<SysOpenApiResourceDO> listByOpenApiId(long openApiId) {
        return super.getList(QDO.openApiInfoId.eq(openApiId));
    }

    /**
     * 获取资源内容
     *
     * @param id
     * @return
     */
    public String getResourceAuto(long id) {
        var bytes = super.getValue(QDO.resourceByte, id);
        if (ArrayUtil.isNotEmpty(bytes)) {
            return new String(bytes);
        }
        return super.getValue(QDO.resource, id);
    }

    /**
     * 获取资源内容
     *
     * @param id
     * @return
     */
    public String getResource(long id) {
        return super.getValue(QDO.resource, id);
    }

    /**
     * 获取资源内容
     *
     * @param id
     * @return
     */
    public byte[] getResourceBytes(long id) {
        return super.getValue(QDO.resourceByte, id);
    }
}
