package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysOpenApiComponentSchemaDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiComponentSchemaDO;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/4
 */
@Repository
public class OpenApiSchemaRepoProc extends BaseRepoProc<SysOpenApiComponentSchemaDO> {
    private static final QSysOpenApiComponentSchemaDO QDO = QSysOpenApiComponentSchemaDO.sysOpenApiComponentSchemaDO;

    public OpenApiSchemaRepoProc() {
        super(QDO);
    }

    /**
     * 删除数据
     *
     * @param openApiId
     */
    @Transactional(rollbackFor = Exception.class)
    public void deleteByOpenApiId(long openApiId) {
        super.delete(QDO.openApiInfoId.eq(openApiId));
    }

    public Long getResourceId(long openApiId, @NotBlank String path) {
        return super.getValue(QDO.resourceId, QDO.schemaPath.eq(path).and(QDO.openApiInfoId.eq(openApiId)));
    }
}
