package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.devops.ProjectVersionPageQueryVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysProjectVersionDO;
import com.elitescloud.cloudt.system.service.model.entity.SysProjectVersionDO;
import org.springframework.stereotype.Repository;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/2
 */
@Repository
public class ProjectVersionRepoProc extends BaseRepoProc<SysProjectVersionDO> {

    private static final QSysProjectVersionDO QDO = QSysProjectVersionDO.sysProjectVersionDO;

    public ProjectVersionRepoProc() {
        super(QDO);
    }

    public SysProjectVersionDO getExistsRecord(String project, String env, String application) {
        var predicate = PredicateBuilder.builder()
                .and(QDO.applicationCode.eq(application))
                .and(QDO.env.eq(env))
                .and(QDO.project.eq(project))
                .build();
        return super.getOne(predicate);
    }

    public PagingVO<SysProjectVersionDO> pageMng(ProjectVersionPageQueryVO queryVO) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.project, queryVO.getProject())
                .andEq(QDO.env, queryVO.getEnv())
                .build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), QDO.modifyTime.desc());
    }
}
