package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.SubUserBO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.SubUserListRespVO;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.model.entity.QSysRoleDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysSubUserDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserRoleDO;
import com.elitescloud.cloudt.system.service.model.entity.SysSubUserDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/27
 */
@Repository
public class SubUserRepoProc extends BaseRepoProc<SysSubUserDO> {
    private static final QSysSubUserDO QDO = QSysSubUserDO.sysSubUserDO;
    private static final QSysRoleDO QDO_ROLE = QSysRoleDO.sysRoleDO;
    private static final QSysUserRoleDO QDO_USER_ROLE = QSysUserRoleDO.sysUserRoleDO;

    public SubUserRepoProc() {
        super(QDO);
    }

    public boolean existsSubUser(long subUserId) {
        return super.exists(QDO.subUserId, subUserId);
    }

    public List<Long> filterExistsSubUser(@NotEmpty Collection<Long> subUserIds) {
        return super.getValueListByValue(QDO.subUserId, QDO.subUserId, subUserIds);
    }

    public List<Long> querySubUserIds(@NotNull BelongType.Belonger belonger) {
        return super.getValueList(QDO.subUserId, QDO.typeId.eq(belonger.getBelongId()).and(QDO.type.eq(belonger.getBelongType().getValue())));
    }

    public List<SubUserListRespVO> querySubUsers(@NotNull BelongType.Belonger belonger, String roleCode) {
        var qBean = Projections.bean(SubUserListRespVO.class, QDO.id, QDO.subUserId, QDO.createTime);
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.typeId, belonger.getBelongId())
                .andEq(QDO.type, belonger.getBelongType().getValue())
                .andIn(StringUtils.hasText(roleCode), QDO.subUserId, () -> JPAExpressions.select(QDO_USER_ROLE.userId).from(QDO_USER_ROLE).where(QDO_USER_ROLE.roleId.eq(
                        JPAExpressions.select(QDO_ROLE.id).from(QDO_ROLE).where(QDO_ROLE.code.eq(roleCode))
                )))
                .build();
        return super.getList(qBean, predicate, QDO.createTime.desc());
    }

    public List<Long> querySubUserIds(Collection<Long> ids) {
        return super.getValueList(QDO.subUserId, ids);
    }

    public SubUserBO getBySubUser(long subUserId) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.subUserId, subUserId)
                .build();
        return super.getOne(qBeanBO(), predicate);
    }

    private QBean<SubUserBO> qBeanBO() {
        return Projections.bean(SubUserBO.class, QDO.subUserId, QDO.type, QDO.typeId, QDO.permissionType);
    }
}
