package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysPositionDO;
import com.elitescloud.cloudt.system.model.entity.QSysPositionOrgDO;
import com.elitescloud.cloudt.system.model.entity.SysPositionDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysOrgDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/3/29
 */
@Repository
public class SysPositionRepoProc extends BaseRepoProc<SysPositionDO> {
    private static final QSysPositionDO QDO = QSysPositionDO.sysPositionDO;
    private static final QSysPositionOrgDO QDO_POST_ORG = QSysPositionOrgDO.sysPositionOrgDO;
    private static final QSysOrgDO QDO_ORG = QSysOrgDO.sysOrgDO;

    public SysPositionRepoProc() {
        super(QDO);
    }

    public List<IdCodeNameParam> queryCodeNames(String orgCode, Long orgId, Integer size, String postName) {
        var predicateBuilder = PredicateBuilder.builder();
        if (orgId != null) {
            predicateBuilder.andIn(QDO.positionCode,
                    JPAExpressions.select(QDO_POST_ORG.positionCode)
                            .from(QDO_POST_ORG)
                            .where(
                                    QDO_POST_ORG.orgCode.eq(
                                            JPAExpressions.select(QDO_ORG.code)
                                                    .from(QDO_ORG)
                                                    .where(QDO_ORG.id.eq(orgId))
                                    )
                            )
                    );
        } else if (CharSequenceUtil.isNotBlank(orgCode)) {
            predicateBuilder.andIn(QDO.positionCode,
                    JPAExpressions.select(QDO_POST_ORG.positionCode)
                            .from(QDO_POST_ORG)
                            .where(QDO_POST_ORG.orgCode.eq(orgCode))
            );
        }

        predicateBuilder.andLike(QDO.positionName, postName);

        var qBean = Projections.bean(IdCodeNameParam.class, QDO.id, QDO.positionCode.as("code"), QDO.positionName.as("name"));
        JPAQuery<IdCodeNameParam> jpaQuery = super.jpaQueryFactory.select(qBean)
                .from(QDO)
                .where(predicateBuilder.build());
        if (size != null) {
            jpaQuery.limit(size);
        }
        return jpaQuery.fetch();
    }

    public List<IdCodeNameParam> queryIdCodeNamesByCodes(@NotEmpty Collection<String> positionCodes) {
        var qBean = Projections.bean(IdCodeNameParam.class, QDO.id, QDO.positionCode.as("code"), QDO.positionName.as("name"));

        return super.getList(qBean, QDO.positionCode.in(positionCodes));
    }
}
