package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.cloudt.system.model.entity.SysSettingDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface SysSettingRepo extends JpaRepository<SysSettingDO, Long>, QuerydslPredicateExecutor<SysSettingDO> {

    Optional<SysSettingDO> findBySettingNo(String settingNo);

    Optional<SysSettingDO> findByIdNotAndSettingNo(Long id, String settingNo);

    void deleteAllByIdIn(List<Long> ids);

    void deleteAllBySettingNoIn(List<String> nos);
}
